#!/bin/sh

SZF_ROUTER_MONITOR_LOCK="/tmp/synoroutermonitor.lock"
SZF_ROUTER_CONF_LOCK="/tmp/routerconf.lock"
SZF_ROUTER_CONF="/etc/portforward/router.conf"
SZF_RULE_CONF="/etc/portforward/rule.conf"
SYNOPORTFORWARD="/usr/syno/bin/synoportforward"
MAX_RETRY=15

has_enabled_rules ()
{
	local ruleConf="$1"
    grep "enabled=1" "$ruleConf" > /dev/null 2&>1
    return $?
}

is_manual_router ()
{
	local routerConf="$1"
	use_custom_account=`synogetkeyvalue $routerConf use_custom_account`
	if [ "on" == "$use_custom_account" ]; then
		return 0
	else
		return 1
	fi
}

run_manual_script ()
{
	(
	#blocking wait for protect /tmp/pfRunningTask
	if flock -x 8; then
		PID=`echo $$`
		#The key, save_rule, will be cleared when process died.
		`/usr/syno/bin/synosetkeyvalue /tmp/pfRunningTask save_rule "$PID"`
		`$SYNOPORTFORWARD --regenerate_rule_conf`
		`$SYNOPORTFORWARD`
		`/usr/syno/bin/synosetkeyvalue /tmp/pfRunningTask save_rule -1`
		flock -u 8
	fi
	)8> ${SZF_ROUTER_CONF_LOCK}
}


post_up () 
{
        if ! has_enabled_rules $SZF_RULE_CONF; then
            return
        fi
        # avoid exec many times when encounter series net interface chain
        (
        if flock -n -x 9; then
                count=0
                while [ $count -lt $MAX_RETRY ]
                do
                        /usr/syno/sbin/ddnsd -e > /tmp/routerIP;
                        EXT_IP=`/usr/syno/bin/synogetkeyvalue /tmp/routerIP "external IP"`;

                        if [ "" != "$EXT_IP" -a "0.0.0.0" != "$EXT_IP" ]; then
                                break;
                        fi

                        count=$(($count+1));
                        sleep 20;
                done
                if [ $count -eq $MAX_RETRY ]; then
                        exit;
                fi
                sleep 5
                GATEWAY_INTERFACE=`ip route | grep default | cut -d ' ' -f 5`
                if [ ! "$IFNAME" == "$GATEWAY_INTERFACE" ]; then
                        return 
                fi
                ROUTER_TYPE=`/bin/get_key_value $SZF_ROUTER_CONF router_type`
                if [ "$ROUTER_TYPE" == "upnp" ]; then
                        SUPPORT_UPNP=`/bin/get_key_value $SZF_ROUTER_CONF support_router_upnp`
                        if [ "$SUPPORT_UPNP" == "yes" ]; then
                            synoservicecfg --reload upnpd
                        elif is_manual_router $SZF_ROUTER_CONF; then
                            # workaround for two kind of manual script router.conf:
                            # Type1: (5.0 or 5.1)
                            # ...
                            # router_type=upnp
                            # support_router_upnp=unknown
                            # ...
                            # Type2:
                            # ...
                            # (no router type)
                            # support_router_upnp=no
                            # ...
                            run_manual_script
                        fi
                elif [ "$ROUTER_TYPE" == "natpmp" ]; then
                        synoservicecfg --reload natpmpd
                elif is_manual_router $SZF_ROUTER_CONF; then
                    #router.conf for manual Type2
                    run_manual_script
                fi
                flock -u 9
                rm ${SZF_ROUTER_MONITOR_LOCK}
        fi
        )9> ${SZF_ROUTER_MONITOR_LOCK}
}

case $1 in
	--sdk-mod-ver)
        	#Print SDK support version
	        echo "1.0"
	;;
	--name)
        	#Print package name
	        echo "SynorouterClient"
	;;
	--pkg-ver)
        	#Print package version
	        echo "1.0"
	;;
	--vendor)
        	#Print package vendor
	        echo "Synology"
	;;
	--pre)
	;;
	--post)
                #check if this interface is gateway interface
	        post_up &
	;;
	*)
	        echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac

